#version 330
#extension GL_EXT_gpu_shader4 : enable
// Fractal Experiment 24Mod01.fsh by aiekick

//https://www.shadertoy.com/view/MlKSRy
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// based on is shader : https://www.shadertoy.com/view/MltXz2

// z * z
vec2 zmul(vec2 a, vec2 b)
{
	//return vec2(a.x*b.x-a.y*b.y, a.x*b.y+b.x*a.y);
    return mat2(a,-a.y,a.x)*b;
}

// 1 / z
vec2 zinv(vec2 a)
{
	return vec2(a.x, -a.y) / dot(a,a);
}

const float AA = 2.;
void main (void)    
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    gl_FragColor = vec4(0);
    
	vec2 g = gl_FragCoord.xy;
	vec2 si = iResolution.xy;
    
    
    for( float m=0.; m<AA; m++ )
    for( float n=0.; n<AA; n++ )
    {
        vec2 offset = vec2(m,n) / AA - 0.5;
        vec2 uv = ((g+offset)*2.-si)/min(si.x,si.y) ;
        uv *= 30. * (sin(10.6+iTime * 0.01)*.5+.5);//zoom
        uv += vec2(-0.2985584,0.558329);
        if (iMouse.z > 0.)
            uv = ((g+offset)*2.-si)/min(si.x,si.y) * 2.;
        vec2 z = uv;
        vec2 c = vec2(0.59,0.8596);
        float it = 0.;
        for (int i=0;i<600;i++)
        {
            z = zinv(zmul(z, z) + c);
            if( log2(log2(dot(z,z)))>1.3 ) break;
            it++;
        }
        if (it <  99.5)
        {
        	float sit = it - log2(dot(zinv(0.1/z),zinv(0.1/z)));
        	gl_FragColor += 0.5 + 0.5*cos( 3.0 + sit*0.075 + vec4(0.0,0.6,1.0,1.0));
        }
    }
    
    gl_FragColor /= AA;
}